﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;

namespace ZeroTrustDemo.Controllers
{
    public class HomeController : Controller
    {
        static HomeController()
        {
            ZeroTrustLibrary.ZeroTrust.InitByKeyPair(
                "https://ag.tryout.gov.tw/identity/api/verifiercheck",
                "MCrGvy8y4wxy4l5yyDhJdDtxv6sJjgm26f4hBVv0M6TINjw4KG4aHL-_jQrTagHnWMag5zC5Rw4JCxh8e1D4eA",
                // X509 spki encode
                "_8m9VRiL-OFUSH1P_GxGZp_FJlcCpXtdf20i257lAeNIbfOFgHj88JopEyC8dyy79T5NKewGIVcN5ZRmckJ0vE_OY0Y7CNYHcdMZ8qLQOnICs5tC2zmQ_k6qPmVa63XxT_s89TuAottInLW8q3Lb7O737E8eco6RSLEUw_G80IazKBuCLf06qPAtcze65aYBVB36092P5wgn6DiD0oVkfe_gR1jAJFlKQUmFYYRt9jD-2yiamcZg0iw5dHA4laC-b_tqfrNP4LAuwYf2QVIuSzGDGO8Y2VPz1jGWWt6-Z7WdSa3fJdPF1-IY3ydx_OWTTPvpTXuvNWt3PrFhmo1Vj6RlHyBJaxnDUF9aVzy1sOfyCstOYwVKJ7c4uFHqiSvc1I7-hQu9P4HFpsHkOKxCCalDqxvrTKsn4Nx233LtxHqBuWDZ4Bppp_al6B-FynSeGG-vp5c6S65uAY1JtGGAWYD8fygi4mbzS8MqnjnF8e3y-KBtOSq1Fm9zOvXGbT9rwYJDQjS2e1Z8mtuBauITi3TNqk_529ovo24pf28m7XMMMTnUoFgfASYQm6i7OhN1KoMcnD7ZVNJikPo5j99z11lbvS25zXCU40oVq-pom_E"
            //// PKCS1 encode
            //"B7nYJ8DaVYJ1PqQYLDIuwwtObqDhIBOzUBNX3C_LM8HsREtRHw1u9ScqO9UI6zqVtyg2CKrxYNRF6_eP1PeZR6pyzKD2_RhP-gUBX3v_5F4ZQkU0aJc9F32shbIh2vjQ8_j_hDJuS48BAyzpP0RmVqzgjZTotO_hvBDDuO0ltphK_SKHhP4m83rkgwnz7YHMBYJlxTN1Dw6-_uq0XhubTNNpvDLxyuUgKNzA10LUfj2w3hMbuB-ZmdgKb87HcuVvPWyjpQV2Gcguv85mGQnE3k5K93hsn2Q1elj2H41JTZPlrydgQIBdmzN8dV0_aTgKSNfIq7vw3GdJwRId_wXq_YwVYkn6qZZHBcO1WitAMnx6Um9LhLVOBC_JUw5_W6Xn95JwnKuReJRgEDpQFxhkXEEv7AwJDf2YR4Bp6a4mzzCoK-6yOGfWYdjgMdfDw66G4LJAyddzwhRcukhPR2uBvAFz7RJrNgBBc8cQJpmFrm3hTezEvToEBCHpPkGQ1MvnZSODSHL5EAeTN9cPEGy6sZB60Bz0dCyC69S8Qa1pI1zn4Xy3dSf2wjTKdrrStCDA"
            );
            ZeroTrustLibrary.ZeroTrust.debugging = true;
        }

        public async Task<ActionResult> Index()
        {
            string nonce = Request.QueryString.Get("nonce");
            string verifier = Request.QueryString.Get("verifier");

            ViewBag.Nonce = nonce;
            ViewBag.Verifier = verifier;
            ViewBag.ErrorMsg = "";
            
            var user = await ZeroTrustLibrary.ZeroTrust.DoVerify(nonce, verifier);
            if (user == null)
            {
                ViewBag.ErrorMsg = "輸入的 verifier 與 nonce 無法獲得使用者資訊";
            }
            else
            {

                ViewBag.ID = user.user.id;
                ViewBag.LoginTime = user.user.login_time;
                ViewBag.ExpireTime = user.user.expire_time;
                ViewBag.Token = user.token;
                ViewBag.Encrypted = user.encryptedData;
                ViewBag.JWT = user.jwt;
                ViewBag.Authority = user.authority;
            }
            

            return View();
        }

        public ActionResult About()
        {
            ViewBag.Message = "123";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "CONTACT";

            return View();
        }
    }
}