﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace ZeroTrustDemo
{
    public class LocalData
    {
        public class RequestRecord
        {
            public string nonce;
            public string request_token;
            public string secret;
            public RequestRecord(string nonce, string token, string secret)
            {
                this.nonce = nonce;
                this.request_token = token;
                this.secret = secret;
            }
        }

        public LocalData()
        {
        }

        private static Dictionary<string, RequestRecord> requestMap;

        static LocalData()
        {
            requestMap = new Dictionary<string, RequestRecord>();
        }

        public static void addRequest(string nonce, string token, string secret)
        {
            string key = nonce;
            if (key == null)
            {
                key = "";
            }
            requestMap.Add(key, new RequestRecord(nonce, token, secret));
        }

        public static RequestRecord getRequestRecord(string nonce)
        {
            string key = nonce;
            if (key == null)
            {
                key = "";
            }
            Console.Out.WriteLine("Nonce: " + key);
            if (requestMap.ContainsKey(key))
            {
                return requestMap[key];
            }
            return null;
        }

        public static void delRequestRecord(string nonce)
        {
            string key = nonce;
            if (key == null)
            {
                key = "";
            }
            requestMap.Remove(key);
        }
    }
}